<div class="container mt-4">
    <h3 class="mb-4"><?= htmlspecialchars($title) ?></h3>

    <?php if (!empty($tasks)): ?>
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Contact</th>
                        <th>Title</th>
                        <th>Due Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($tasks as $task): ?>
                        <tr>
                            <td><?= htmlspecialchars($task['contact_id']) ?></td>
                            <td><?= htmlspecialchars($task['title']) ?></td>
                            <td><?= date('Y-m-d H:i', strtotime($task['due_date'])) ?></td>
                            <td>
                                <span class="badge bg-<?= $task['status'] === 'pending' ? 'danger' : 'success' ?>">
                                    <?= ucfirst($task['status']) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info">No tasks found in this category.</div>
    <?php endif; ?>

    <div class="mt-3">
        <a href="<?= BASE_URL ?>/DashboardController/agent" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to Dashboard
        </a>
    </div>
</div>
