<div class="container mt-4">
    <div class="card shadow-sm rounded-3 border-0">
        <div class="card-header bg-warning bg-gradient text-dark d-flex align-items-center">
            <i class="bi bi-pencil-square me-2 fs-5"></i>
            <h5 class="mb-0">Edit Task</h5>
        </div>

        <div class="card-body">
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger shadow-sm rounded">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="post" action="">
                <div class="mb-3">
                    <label class="form-label fw-semibold">Task Title</label>
                    <input type="text" name="title" class="form-control shadow-sm"
                        value="<?= htmlspecialchars($task['title']) ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Due Date</label>
                    <input type="datetime-local" name="due_date" class="form-control shadow-sm"
                        value="<?= date('Y-m-d\TH:i', strtotime($task['due_date'])) ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-semibold">Status</label>
                    <select name="status" class="form-select shadow-sm">
                        <option value="pending" <?= $task['status'] === 'pending' ? 'selected' : '' ?>>Pending</option>
                        <option value="completed" <?= $task['status'] === 'completed' ? 'selected' : '' ?>>Completed</option>
                    </select>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-success shadow-sm">
                        <i class="bi bi-check-circle me-1"></i> Update Task
                    </button>
                    <a href="<?= BASE_URL ?>/TaskController/contact/<?= $task['contact_id'] ?>" class="btn btn-outline-secondary shadow-sm">
                        <i class="bi bi-x-circle me-1"></i> Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
