<!--<?php session_start(); ?>-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= $title ?? 'CRM Demo' ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 5.3 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Optional modern icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background-color: #f5f7fa;
        }
        .navbar-brand {
            font-weight: bold;
            font-size: 1.2rem;
        }
        main.container {
            padding-top: 30px;
            padding-bottom: 50px;
        }
        
        
      .date-picker {
        position: relative;
      }
      .date-picker .display {
        padding-right: 36px; /* space for icon */
      }
      .date-picker .calendar-btn {
        position: absolute;
        right: 8px;
        top: 50%;
        transform: translateY(-50%);
        border: 0;
        background: transparent;
        cursor: pointer;
        line-height: 1;
        padding: 0;
        font-size: 18px;
        color: #6c757d;
      }
      .date-picker .native-date {
        position: absolute;
        inset: 0 36px 0 0;   
        opacity: 0;          
        pointer-events: none;
      }
      .date-picker .native-date::-webkit-calendar-picker-indicator {
        opacity: 0;
      }


    </style>
</head>
<body>

<?php if (isset($_SESSION['user_id'])): ?>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="<?= BASE_URL ?>/DashboardController/<?= $_SESSION['user_role'] ?>">
                <i class="bi bi-bar-chart-line-fill"></i> CRM Panel
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= BASE_URL ?>/contacts"><i class="bi bi-person-lines-fill"></i> Contacts</a>
                    </li>
                    <?php if ($_SESSION['user_role'] === 'admin'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>/contacts/assign"><i class="bi bi-people-fill"></i> Assign</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= BASE_URL ?>/contacts/manageAssignments"><i class="bi bi-arrow-repeat"></i> Manage</a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= BASE_URL ?>/LoginController/logout"><i class="bi bi-box-arrow-right"></i> Logout</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
<?php endif; ?>

<main class="container">
    <?php require $viewPath; ?>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>

<script>
    (function () {
    function formatDate(iso) {
      if (!iso) return "";
      const [y, m, d] = iso.split("-");
      return `${d}/${m}/${y}`;
    }

    function wireDatePair(id) {
      const input = document.getElementById(id);
      const display = document.getElementById(id + "_display");
      const btn = document.querySelector(`.calendar-btn[data-target="${id}"]`);

      if (!input || !display || !btn) return;

      display.value = formatDate(input.value);

      input.addEventListener('change', function () {
        display.value = formatDate(this.value);
      });

      btn.addEventListener('click', function () {
        input.style.pointerEvents = 'auto';
        if (typeof input.showPicker === 'function') {
          input.showPicker();
        } else {
          input.focus();
          input.click();
        }
        setTimeout(() => { input.style.pointerEvents = 'none'; }, 0);
      });
    }

    wireDatePair('invoice_date');
    wireDatePair('due_date');
  })();
</script>

</body>
</html>
