

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="bi bi-receipt"></i> Invoices & Quotes</h3>
        <?php if (isset($role) && ($role === 'admin' || $role === 'agent')): ?>
        <div>
            <a href="<?= BASE_URL ?>/invoice/add" class="btn btn-success">
                <i class="bi bi-plus-circle"></i> Add Invoice/Quote
            </a>
            <a href="<?= BASE_URL ?>/dashboard/<?= $role ?? 'agent' ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
        <?php endif; ?>
    </div>

    <!-- Flash messages -->
    <?php if (!empty($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>
    <?php if (!empty($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>

    <!-- Filters -->
    <form method="get" class="row g-2 mb-4">
        <div class="col-md-2">
            <input type="text" name="id" class="form-control" placeholder="Invoice #"
                   value="<?= htmlspecialchars($filters['id'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="customer" class="form-control" placeholder="Customer"
                   value="<?= htmlspecialchars($filters['customer'] ?? '') ?>">
        </div>
        <div class="col-md-2">
            <select name="status" class="form-select">
                <option value="">All Status</option>
                <option value="Pending" <?= ($filters['status'] ?? '')==='Pending'?'selected':'' ?>>Pending</option>
                <option value="Paid" <?= ($filters['status'] ?? '')==='Paid'?'selected':'' ?>>Paid</option>
                <option value="Overdue" <?= ($filters['status'] ?? '')==='Overdue'?'selected':'' ?>>Overdue</option>
            </select>
        </div>
        <div class="col-md-2">
            <select name="invoice_type" class="form-select">
                <option value="">All Types</option>
                <option value="Invoice" <?= ($filters['invoice_type'] ?? '')==='Invoice'?'selected':'' ?>>Invoice</option>
                <option value="Quote" <?= ($filters['invoice_type'] ?? '')==='Quote'?'selected':'' ?>>Quote</option>
            </select>
        </div>
        <div class="col-md-3">
            <input type="date" name="due_date" class="form-control"
                   value="<?= htmlspecialchars($filters['due_date'] ?? '') ?>">
        </div>
        <div class="col-md-12 text-end">
            <button type="submit" class="btn btn-primary"><i class="bi bi-search"></i> Search</button>
            <button type="button" class="btn btn-outline-secondary" onclick="window.location='<?= BASE_URL ?>/invoice'">Reset</button>
        </div>
    </form>

    <!-- Invoices table -->
    <?php if (!empty($invoices)): ?>
        <div class="table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Billing #</th>
                        <th>Type</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Invoice Date</th>
                        <th>Due Date</th>
                        <th>Status</th>
                        <th>Created Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($invoices as $invoice): ?>
                        <tr class="text-center">
                            <td><?= str_pad(htmlspecialchars($invoice['id']), 5, '0', STR_PAD_LEFT) ?></td>
                            <td><?= htmlspecialchars($invoice['invoice_type']) ?></td>
                            <td><?= htmlspecialchars($invoice['customer_name']) ?></td>
                            <td>R<?= number_format($invoice['amount'], 2) ?></td>
                            <td><?= htmlspecialchars($invoice['invoice_date']) ?></td>
                            <td><?= htmlspecialchars($invoice['due_date']) ?></td>
                            <td>
                                <?php if ($invoice['status'] === 'Paid'): ?>
                                    <span class="badge bg-success">Paid</span>
                                <?php elseif ($invoice['status'] === 'Pending'): ?>
                                    <span class="badge bg-warning text-dark">Pending</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Overdue</span>
                                <?php endif; ?>
                            </td>
                            <td><?= date('Y-m-d', strtotime($invoice['created_at'])) ?></td>
                            <td>
                                <a href="<?= BASE_URL ?>/invoice/view/<?= $invoice['id'] ?>" class="btn btn-sm btn-outline-info" title="View"><i class="bi bi-eye"></i></a>
                                <a href="<?= BASE_URL ?>/invoice/download/<?= $invoice['id'] ?>" target="_blank" class="btn btn-sm btn-outline-success" title="Download PDF"><i class="bi bi-download"></i></a>
                                <a href="<?= BASE_URL ?>/invoice/downloadTaxInvoice/<?= $invoice['id'] ?>" class="btn btn-sm btn-outline-success" title="View Tax Invoice PDF" target="_blank"> <i class="bi bi-file-earmark-pdf"></i> </a>
                                
                                <a href="<?= BASE_URL ?>/invoice/edit/<?= $invoice['id'] ?>" class="btn btn-sm btn-outline-warning" title="Edit"><i class="bi bi-pencil"></i></a>
                                <a href="<?= BASE_URL ?>/invoice/delete/<?= $invoice['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this invoice?');" title="Delete"><i class="bi bi-trash"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if (!empty($totalPages) && $totalPages > 1): ?>
            <nav>
                <ul class="pagination justify-content-center">
                    <li class="page-item <?= ($currentPage <= 1) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $currentPage - 1])) ?>">Previous</a>
                    </li>
                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <li class="page-item <?= ($i == $currentPage) ? 'active' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?= ($currentPage >= $totalPages) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $currentPage + 1])) ?>">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    <?php else: ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle"></i> No invoices found.
        </div>
    <?php endif; ?>
</div>


