<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="bi bi-chat-dots-fill"></i> All Interactions</h3>
        <a href="<?= BASE_URL ?>/dashboard/<?= $role ?? 'agent' ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to Dashboard
        </a>
    </div>

    <?php if (!empty($interactions)): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th><i class="bi bi-person"></i> Contact</th>
                        <th><i class="bi bi-ui-checks"></i> Type</th>
                        <th><i class="bi bi-clock-history"></i> Date</th>
                        <th><i class="bi bi-person-circle"></i> By</th>
                        <th><i class="bi bi-chat-text"></i> Summary</th>
                        <th><i class="bi bi-gear"></i> Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($interactions as $i): ?>
                        <tr>
                            <td><?= htmlspecialchars($i['contact_name']) ?></td>
                            <td><?= htmlspecialchars($i['type']) ?></td>
                            <td><?= date('Y-m-d H:i', strtotime($i['interaction_date'])) ?></td>
                            <td><?= htmlspecialchars($i['user_name']) ?></td>
                            <td><?= htmlspecialchars($i['summary']) ?></td>
                            <td>
                                <a href="<?= BASE_URL ?>/interaction/edit/<?= $i['id'] ?>" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= BASE_URL ?>/interaction/delete/<?= $i['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info text-center">📭 No interactions found.</div>
    <?php endif; ?>

    <?php if (isset($totalPages) && $totalPages > 1): ?>
        <nav>
            <ul class="pagination justify-content-center mt-4">
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
    <?php endif; ?>

    <div class="mt-3">
        
    </div>
</div>
