<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">📝 Add Interaction</h4>
        </div>
        <div class="card-body">
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="post" action="">
                <input type="hidden" name="contact_id" value="<?= htmlspecialchars($contact_id) ?>">

                <div class="mb-3">
                    <label class="form-label">Interaction Type</label>
                    <select class="form-select" name="type" required>
                        <option value="">-- Select Type --</option>
                        <option value="Call">Call</option>
                        <option value="Email">Email</option>
                        <option value="Meeting">Meeting</option>
                        <option value="WhatsApp">WhatsApp</option>
                        <option value="Follow-Up">Follow-Up</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Date & Time</label>
                    <input type="datetime-local" name="interaction_date" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Summary</label>
                    <textarea name="summary" class="form-control" rows="4" required></textarea>
                </div>

                <button type="submit" class="btn btn-success">Save Interaction</button>
                <a href="<?= BASE_URL ?>/contacts/<?= htmlspecialchars($contact_id) ?>" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
