<div class="text-center mb-4">
    <h1 class="display-5 fw-bold">Welcome, <?= htmlspecialchars($_SESSION['user_name']) ?> 👋</h1>
    <p class="text-muted">You're logged in as <strong><?= ucfirst($_SESSION['user_role']) ?></strong>.</p>
</div>

<div class="row g-4 justify-content-center">
    <div class="col-md-4">
        <div class="card shadow-sm border-0">
            <div class="card-body text-center">
                <h5 class="card-title">📇 Contacts</h5>
                <p class="card-text">View and manage your contacts.</p>
                <a href="<?= BASE_URL ?>/contacts" class="btn btn-outline-primary w-100">Go to Contacts</a>
            </div>
        </div>
    </div>

    <?php if ($_SESSION['user_role'] === 'admin'): ?>
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">📄 Manage Invoices & Quotes</h5>
                    <p class="card-text">Create, edit, and monitor all customer billing documents.</p>
                    <a href="<?= BASE_URL ?>/invoice" class="btn btn-outline-primary w-100">Go to Invoices & Quotes</a>
                </div>
            </div>
        </div>
        


        <!-- Products Card -->
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">📦 Manage Products</h5>
                    <p class="card-text">Add, edit, and organize your product catalog.</p>
                    <a href="<?= BASE_URL ?>/product" class="btn btn-outline-warning w-100">Go to Products</a>
                </div>
            </div>
        </div>
        
        <!-- Customers Card -->
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">👤 Manage Customers</h5>
                    <p class="card-text">View and manage all your customers.</p>
                    <a href="<?= BASE_URL ?>/customer" class="btn btn-outline-info w-100">Go to Customers</a>
                </div>
            </div>
        </div>

        
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">👤 Manage Users</h5>
                    <p class="card-text">Add, edit and delete users.</p>
                    <a href="<?= BASE_URL ?>/users/" class="btn btn-outline-success w-100">Go to Users</a>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">💬 Manage Interactions</h5>
                    <p class="card-text">Add, edit and delete interactions.</p>
                    <a href="<?= BASE_URL ?>/interaction/index" class="btn btn-outline-success w-100">
                        Go to Interactions
                    </a>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">📋 Manage Tasks</h5>
                    <p class="card-text">Add, filter, and manage all tasks.</p>
                    <a href="<?= BASE_URL ?>/task/index" class="btn btn-outline-primary w-100">
                        View All Tasks
                    </a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">📋 Manage Leads</h5>
                    <p class="card-text">Add, filter, and manage all leads.</p>
                    <a href="<?= BASE_URL ?>/lead/index" class="btn btn-outline-primary w-100"> View All Leads</a>
                       
                    </a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center">
                    <h5 class="card-title">📧 Send Task Reminders</h5>
                    <p class="card-text">Manually send overdue task reminders with optional CCs.</p>
                    <a href="<?= BASE_URL ?>/reminder/manual" class="btn btn-outline-danger w-100">Open Reminder Panel</a>
                </div>
            </div>
        </div>
        
        

    <?php endif; ?>
</div>
