<div class="card shadow-sm">
    <div class="card-header bg-primary text-white">
        <h4 class="mb-0">👥 Manage Assigned Contacts</h4>
    </div>

    <div class="card-body">
        <?php if (!empty($_GET['success'])): ?>
            <div class="alert alert-success">✅ Contacts reassigned successfully.</div>
        <?php endif; ?>

        <!-- 🔍 Search Form -->
        <form method="GET" action="<?= BASE_URL ?>/contacts/manageAssignments" class="row g-2 mb-4">
            <div class="col-md-6">
                <input type="text" name="q" class="form-control" placeholder="Search contact..." value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
            </div>
            <div class="col-md-4">
                <select name="agent" class="form-select">
                    <option value="">All agents</option>
                    <?php foreach ($agents as $agent): ?>
                        <option value="<?= $agent['id'] ?>" <?= ($_GET['agent'] ?? '') == $agent['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($agent['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Search</button>
            </div>
        </form>

        <!-- ⚙️ Bulk Reassignment Form -->
        <form method="POST" action="<?= BASE_URL ?>/contacts/bulkReassignAssigned">
            <input type="hidden" name="action" id="bulk-action" value="reassign">

            <div class="row g-3 align-items-center mb-3">
                <div class="col-md-6">
                    <select name="new_agent_id" id="agent-select" class="form-select" required>
                        <option value="">-- Select New Agent --</option>
                        <?php foreach ($agents as $agent): ?>
                            <option value="<?= $agent['id'] ?>"><?= htmlspecialchars($agent['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div class="form-check mb-2">
                <input type="checkbox" class="form-check-input" id="select-all">
                <label class="form-check-label" for="select-all">Select All</label>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-light">
                        <tr>
                            <th>Select</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Assigned Agent</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($contacts as $contact): ?>
                            <tr>
                                <td><input type="checkbox" name="contact_ids[]" class="form-check-input contact-checkbox" value="<?= $contact['id'] ?>"></td>
                                <td><?= htmlspecialchars($contact['name']) ?></td>
                                <td><?= htmlspecialchars($contact['email']) ?></td>
                                <td><?= htmlspecialchars($contact['assigned_name'] ?? '—') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <?php if (!empty($totalPages) && $totalPages > 1): ?>
    <nav class="mt-4">
        <ul class="pagination justify-content-center">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                    <a class="page-link"
                       href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>">
                        <?= $i ?>
                    </a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
<?php endif; ?>

            </div>

            <div class="d-flex gap-2 mt-3">
                <button type="submit" class="btn btn-success" onclick="document.getElementById('bulk-action').value='reassign'">🔁 Reassign Selected</button>
                <button type="submit" class="btn btn-danger" onclick="document.getElementById('bulk-action').value='unassign'">❌ Unassign Selected</button>
            </div>
        </form>
        
        

        <hr class="mt-5">
        <a href="<?= BASE_URL ?>/DashboardController/admin" class="btn btn-secondary">← Back to Dashboard</a>
    </div>
</div>

<script>
document.getElementById('select-all').addEventListener('change', function () {
    document.querySelectorAll('.contact-checkbox').forEach(cb => cb.checked = this.checked);
});
</script>
