<!-- views/contacts/import.php -->
<div class="container mt-4">
    <div class="card shadow-sm border-0 rounded">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-upload me-2"></i> Import Leads</h5>
        </div>
        <div class="card-body">
            <?php if (!empty($success)): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <?php elseif (!empty($error)): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form action="<?= BASE_URL ?>/ContactsController/importCsv" method="post" enctype="multipart/form-data">
                <div class="mb-3">
                    <label for="csv_file" class="form-label fw-semibold">Upload CSV File</label>
                    <input type="file" name="csv_file" class="form-control" required accept=".csv">
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-file-earmark-arrow-up"></i> Import Leads
                </button>
                <a href="<?= BASE_URL ?>/contacts" class="btn btn-outline-secondary ms-2">
                    <i class="bi bi-arrow-left"></i> Back
                </a>
            </form>
        </div>
    </div>
</div>
